/**************************************************************************************************
 * SMAC implementation.
 * 
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
***************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***********************************************************************************************//*!
**************************************************************************************************/

#ifndef SMAC_H_
#define SMAC_H_

/************************************************************************************
*************************************************************************************
* Includes
*************************************************************************************
************************************************************************************/

#include "SMAC_Interface.h"
#include "Phy.h"
#include "EmbeddedTypes.h"

extern void MCPSDataConfirm(txStatus_t);
extern void MCPSDataIndication(rxPacket_t *);

/************************************************************************************
*************************************************************************************
* Private Prototypes
*************************************************************************************
************************************************************************************/
phyPacket_t * SmacFormatTxPacket(txPacket_t *psTxPacket);
void SmacSetRxTimeout(uint32_t timeoutSymbols);

#define smacPreambleSizeOf16_c			(16)
#define smacPreambleSizeOf3_c			(3)

/*smacParametersValidation_d:
TRUE :  SMAC primitives validate their incoming parameters.
FALSE:  SMAC primitives do their stuff without validating their incoming 
        parameters
*Note: Setting this as FALSE will compile a smaller foot print SMAC.
*/
#define smacParametersValidation_d      	TRUE

/*smacInitializationValidation_d:
TRUE :  SMAC primitives validate whether SMAC is initialized or not.
FALSE:  SMAC primitives don't care about SMAC's initialization.
*Note: Setting this as FALSE will compile a smaller foot print SMAC.
*/
#define smacInitializationValidation_d  	TRUE

#define IsBroadcastMessage(destAddress)		(0xFF == destAddress)

/************************************************************************************
*************************************************************************************
* Module Type definitions
*************************************************************************************
************************************************************************************/

typedef enum smacStates_tag {
  mSmacStateIdle_c,
  mSmacStateTransmitting_c,
  mSmacStateReceiving_c,
  mSmacStateScanningChannels_c,
  mSmacStatePerformingTest_c,
  mSmacStateHibernate_c, 
  mSmacStateDoze_c    
} smacStates_t;

typedef union flagsRegister_tag{
  uint8_t entryRegister;
  struct flags_tag{
    uint8_t flag0       :1;                                       
    uint8_t flag1       :1;                                       
    uint8_t flag2       :1;                                       
    uint8_t flag3       :1;                                       
    uint8_t flag4       :1;                                       
    uint8_t flag5       :1;                                       
    uint8_t flag6       :1;                                       
    uint8_t flag7       :1;                                       
  }flags;
}flagsRegister_t;

typedef union prssPacketPtr_tag
{
  uint8_t*    smacScanResultsPointer;     
  rxPacket_t  *smacRxPacketPointer;
  phyPacket_t *smacTxPacketPointer;
}prssPacketPtr_t;

/************************************************************************************
*************************************************************************************
* Private definitions
*************************************************************************************
************************************************************************************/
 extern flagsRegister_t smacFlags;

#define mSmacInitialized         (smacFlags.flags.flag1)
#define mSmacPerformingPRBS9     (smacFlags.flags.flag3)
#define mSmacTimeoutAsked        (smacFlags.flags.flag4)
#define mSmacPerformingCCAScan   (smacFlags.flags.flag5) 
#define mSmacPerformingEDScan    (smacFlags.flags.flag6) 
#define mSmacPerformingED        (smacFlags.flags.flag7) 

/* SMAC version defines */
#define mMajorSmacV_c   (2)
#define mMiddleSmacV_c  (3)
#define mMinorSmacV_c   (2)
#define mYearSmacV_c    (11)
#define mMonthSmacV_c   (11)
#define mDaySmacV_c     (18)
#define mConsSmacV_c    (6)

#if (mMajorSmacV_c > 255) || (mMiddleSmacV_c > 255) || (mMinorSmacV_c > 255)
 #error "Codebase version out of range"
#endif

#if (mYearSmacV_c > 255) || (mMonthSmacV_c > 12) || (mMonthSmacV_c < 1) || (mDaySmacV_c > 31) || (mDaySmacV_c<1)
 #error "Version date out of range"
#endif

#if (mConsSmacV_c > 255)
 #error "Consecutive number of SMAC version out of range"
#endif

/* PHY version defines */
#define mMajorPhyV_c   (2)
#define mMiddlePhyV_c  (3)
#define mMinorPhyV_c   (1)
#define mYearPhyV_c    (11)
#define mMonthPhyV_c   (11)
#define mDayPhyV_c     (4)
#define mConsPhyV_c    (6)

#if (mMajorPhyV_c > 255) || (mMiddlePhyV_c > 255) || (mMinorPhyV_c > 255)
 #error "Codebase version out of range"
#endif

#if (mYearPhyV_c > 255) || (mMonthPhyV_c > 12) || (mMonthPhyV_c < 1) || (mDayPhyV_c > 31) || (mDayPhyV_c<1)
 #error "Version date out of range"
#endif

#if (mConsPhyV_c > 255)
 #error "Consecutive number of SMAC version out of range"
#endif

#define gSwSmacVersionLength_c   7 
#define gSwPhyVersionLength_c    7
 
#endif /* SMAC_H_ */
 